package demo.module;



import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import netsdk.callback.impl.SUBSCRIBE_CALLBACK_IMPL;
import netsdk.lib.*;
import netsdk.lib.DeviceSdk.LLong;
import netsdk.struct.*;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import demo.common.LocalData;

/**
 * IVSS 和 IPC-FR 人脸功能接口实现, IPC-FD只支持人脸检测事件
 */

public class FaceRecognitionModule {	
	// 查找句柄
	private static LLong m_FindHandle = null;   
	
	// 查询密令
	public static int nToken = 0;
	
	////////////////////////////////  人脸识别 和 人脸检测 事件  /////////////////////////////////////////////
	/**
	 * 人脸识别事件和人脸检测事件订阅
	 * @param callback 回调函数
	 * @return true:成功    false:失败
	 */
	public static boolean Subscrib(SUBSCRIBE_CALLBACK_IMPL callback) {
		boolean ret =  LoginModule.netsdk.NET_SDK_SetSubscribCallBack(callback, null);
        if(!ret) {
        	System.err.println("NET_SDK_SetSubscribCallBack Failed, Error:" + ToolKits.getErrorCodePrint());
        } else {
        	System.out.println("订阅成功！");
        }
		return ret;
	}
		
	///////////////////////////////////////  人脸库的增、删、改、查  ////////////////////////////////
	
	/**
	 * 查询人脸库
	 * @param groupId 需要查找的人脸库ID; 为空表示查找所有的人脸库
	 */
	public static NET_SDK_FACE_INFO_GROUP_ITEM[] findGroupInfo() {	
		NET_SDK_FACE_INFO_GROUP_ITEM[] groupInfoRet = null;
		
		Pointer pNativeData = new Memory(1024 * 1024); 
		IntByReference lpBytesReturned = new IntByReference();
		boolean ret = LoginModule.netsdk.NET_SDK_FaceMatchOperate(LoginModule.m_hLoginHandle, ErrorCodeAndConst.NET_SDK_GET_FACE_INFO_GROUP_LIST,
				null, 0, pNativeData,  1024*1024, lpBytesReturned);
		if(ret && lpBytesReturned.getValue() > 0) {
			NET_SDK_FACE_INFO_GROUP_ITEM nsfigi = new NET_SDK_FACE_INFO_GROUP_ITEM();
			
			int len = nsfigi.size();
			int restLen = lpBytesReturned.getValue();
			int offSetLen = 0;
			int num = lpBytesReturned.getValue() / len;
			if(num > 0) {
				groupInfoRet = new NET_SDK_FACE_INFO_GROUP_ITEM[num];
				for(int i = 0;i< num;i++) {
					groupInfoRet[i] =  new NET_SDK_FACE_INFO_GROUP_ITEM();
					CommonFunctions.GetPointerDataToStruct(pNativeData, offSetLen, groupInfoRet[i]);
					groupInfoRet[i].read();
					
					offSetLen += len;//地址偏移
					restLen -= len;//剩余长度
				}
			}
			
		}
		// 释放内存
		long peer = Pointer.nativeValue(pNativeData);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(pNativeData, 0);			
		return groupInfoRet;
	}
	
	/**
	 * 添加人脸库
	 * @param groupName 需要添加的人脸库名称
	 */
	public static boolean addGroup(String groupName) {
		NET_SDK_FACE_INFO_GROUP_ADD  addGroupInfo = new NET_SDK_FACE_INFO_GROUP_ADD();
		addGroupInfo.property = ErrorCodeAndConst.NET_SDK_FACE_INFO_GROUP_PROPERTY_LIMITED;
		// 人脸库名称
		try {
			System.arraycopy(groupName.getBytes("UTF-8"), 0, addGroupInfo.name, 0, groupName.getBytes("UTF-8").length);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}   
		
		Pointer pInputData = new Memory(addGroupInfo.size()); 
		CommonFunctions.SetStructDataToPointer(addGroupInfo, pInputData, 0);
		IntByReference lpBytesReturned = new IntByReference();
		boolean bRet = LoginModule.netsdk.NET_SDK_FaceMatchOperate(LoginModule.m_hLoginHandle, ErrorCodeAndConst.NET_SDK_ADD_FACE_INFO_GROUP, 
				pInputData, addGroupInfo.size(), null, 0, lpBytesReturned);	
		
		// 释放内存
		long peer = Pointer.nativeValue(pInputData);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(pInputData, 0);
		
		return bRet;
	}
	
	/**
	 * 修改人脸库
	 * @param groupName 修改后的人脸库名称
	 * @param groupId 需要修改的人脸库ID
	 */
	public static boolean modifyGroup(String groupName, String groupId) {
		NET_SDK_FACE_INFO_GROUP_ITEM modifyGroupInfo = LocalData.faceGroup.get(Integer.parseInt(groupId));
			
		NET_SDK_FACE_INFO_GROUP_ITEM sIn = new NET_SDK_FACE_INFO_GROUP_ITEM();
		try {
            System.arraycopy(groupName.getBytes("UTF-8"), 0, sIn.name, 0, groupName.getBytes("UTF-8").length);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
		System.arraycopy(modifyGroupInfo.guid, 0, sIn.guid, 0, modifyGroupInfo.guid.length);
		sIn.property = ErrorCodeAndConst.NET_SDK_FACE_INFO_GROUP_PROPERTY_ALLOW;
        sIn.enableAlarmSwitch = 1;
        sIn.groupId = modifyGroupInfo.groupId;
		
		Pointer pInputData = new Memory(sIn.size()); 
		CommonFunctions.SetStructDataToPointer(sIn, pInputData, 0);
		IntByReference lpBytesReturned = new IntByReference();
		boolean bRet = LoginModule.netsdk.NET_SDK_FaceMatchOperate(LoginModule.m_hLoginHandle, ErrorCodeAndConst.NET_SDK_SET_FACE_INFO_GROUP, 
				pInputData, sIn.size(), null, 0, lpBytesReturned);					
		if(bRet) {
			System.out.println("修改人脸库成功.");
		}
		// 释放内存
		long peer = Pointer.nativeValue(pInputData);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(pInputData, 0);
		
		return bRet;
	}
	
	/**
	 * 删除人脸库
	 * @param groupId 需要删除的人脸库ID; 为空表示删除所有的人脸库
	 */
	public static boolean deleteGroup(String groupId) {
		NET_SDK_FACE_INFO_GROUP_ITEM deleteGroupInfo = LocalData.faceGroup.get(Integer.parseInt(groupId));		
		NET_SDK_FACE_INFO_GROUP_DEL sIn = new NET_SDK_FACE_INFO_GROUP_DEL();
		
		System.arraycopy(deleteGroupInfo.guid, 0, sIn.guid, 0, deleteGroupInfo.guid.length);
        Memory lpInBuffer = new Memory(sIn.size());
        CommonFunctions.SetStructDataToPointer(sIn, lpInBuffer, 0);
        IntByReference lpBytesReturned = new IntByReference();
				
		boolean bRet = LoginModule.netsdk.NET_SDK_FaceMatchOperate(LoginModule.m_hLoginHandle, ErrorCodeAndConst.NET_SDK_DEL_FACE_INFO_GROUP, 
				lpInBuffer, sIn.size(),null,0,lpBytesReturned);
		
		if(bRet) {
			System.out.println("删除人脸库成功.");
		} 
		// 释放内存
		long peer = Pointer.nativeValue(lpInBuffer);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(lpInBuffer, 0);
		
		return bRet;
	}
	/**
	 * 查询人脸库中的人脸数量
	 * @param groupId 需要查询的人脸库ID; 
	 */
	public static int getFaceNum(String groupId) {
		int num = 0;
		NET_SDK_FACE_INFO_GROUP_ITEM groupInfo = LocalData.faceGroup.get(Integer.parseInt(groupId));
		
		NET_SDK_FACE_INFO_LIST_GET listGet = new NET_SDK_FACE_INFO_LIST_GET();
		listGet.groupId = groupInfo.groupId;
		listGet.pageIndex = 1;
		listGet.pageSize = 10;
				
		Pointer pInputData = new Memory(listGet.size()); 
		CommonFunctions.SetStructDataToPointer(listGet, pInputData, 0);
		IntByReference lpBytesReturned = new IntByReference();
				
		Pointer pOutputData = new Memory(1024*1024);
		
		boolean bRet = LoginModule.netsdk.NET_SDK_FaceMatchOperate(LoginModule.m_hLoginHandle, ErrorCodeAndConst.NET_SDK_GET_FACE_INFO_LIST, 
				pInputData, listGet.size(), pOutputData, 1024 * 1024, lpBytesReturned);	
		if(bRet) {
			NET_SDK_FACE_INFO_LIST faceList = new NET_SDK_FACE_INFO_LIST();
			
			CommonFunctions.GetPointerDataToStruct(pOutputData, 0, faceList);
			faceList.read();
			num = faceList.totalNum;						
		}
		//释放内存
		long peer = Pointer.nativeValue(pInputData);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(pInputData, 0);
		
		peer = Pointer.nativeValue(pOutputData);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(pOutputData, 0);
		return num;		
	}

	
	/**
	 * 查询人脸库中的人脸
	 * @param groupId 需要查询的人脸库ID; 
	 */
	public static NET_SDK_FACE_INFO_LIST_ITEM[] getFaceInfo(String groupId, int nBeginNum) {
		NET_SDK_FACE_INFO_LIST_ITEM[] faceItemRes = null;
		
		NET_SDK_FACE_INFO_GROUP_ITEM groupInfo = LocalData.faceGroup.get(Integer.parseInt(groupId));
		
		NET_SDK_FACE_INFO_LIST_GET listGet = new NET_SDK_FACE_INFO_LIST_GET();
		listGet.groupId = groupInfo.groupId;
		listGet.pageIndex = 1;
		listGet.pageSize = 10;
		
		
		Pointer pInputData = new Memory(listGet.size()); 
		CommonFunctions.SetStructDataToPointer(listGet, pInputData, 0);
		IntByReference lpBytesReturned = new IntByReference();
		
		
		Pointer pOutputData = new Memory(1024*1024);
		
		boolean bRet = LoginModule.netsdk.NET_SDK_FaceMatchOperate(LoginModule.m_hLoginHandle, ErrorCodeAndConst.NET_SDK_GET_FACE_INFO_LIST, 
				pInputData, listGet.size(), pOutputData, 1024 * 1024, lpBytesReturned);	
		if(bRet) {
			NET_SDK_FACE_INFO_LIST faceList = new NET_SDK_FACE_INFO_LIST();
			
			CommonFunctions.GetPointerDataToStruct(pOutputData, 0, faceList);
			faceList.read();
			if(faceList.listNum < 1) {
				//return faceItemRes;
			}
			if(faceList.listNum > nBeginNum) {
				faceItemRes = new NET_SDK_FACE_INFO_LIST_ITEM[faceList.listNum - nBeginNum];
				int offSetLen = (new NET_SDK_FACE_INFO_LIST_ITEM()).size() * nBeginNum;
				for(int i = 0;i < faceList.listNum - nBeginNum;i++) {
					faceItemRes[i] = new NET_SDK_FACE_INFO_LIST_ITEM();
					CommonFunctions.GetPointerDataToStruct(faceList.pFaceInfoListItem, offSetLen, faceItemRes[i]);
					faceItemRes[i].read();
					offSetLen += faceItemRes[i].size();								
				}
			}
//			else {
//				faceItemRes = new NET_SDK_FACE_INFO_LIST_ITEM[faceList.listNum];
//				int offSetLen = 0;
//				for(int i = 0;i<faceList.listNum;i++) {
//					faceItemRes[i] = new NET_SDK_FACE_INFO_LIST_ITEM();
//					CommonFunctions.GetPointerDataToStruct(faceList.pFaceInfoListItem, offSetLen, faceItemRes[i]);
//					faceItemRes[i].read();
//					offSetLen += faceItemRes[i].size();								
//				}
//			}
			
			
			
			
		}
		//释放内存
		long peer = Pointer.nativeValue(pInputData);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(pInputData, 0);
		
		peer = Pointer.nativeValue(pOutputData);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(pOutputData, 0);
		return faceItemRes;		
	}

	/////////////////////////////  按通道布控、撤控   ///////////////////////////////////////

	/////////////////////////////   人员操作    ////////////////////////////////////////////
	
	/**
	 * 添加人员
	 * @param groupId  人脸库ID
	 * @param memory  图片数据
	 * @param personName 姓名
	 * @param sex  性别
	 * @param isBirthday 是否下发生日
	 * @param birthday  生日
	 * @param byIdType  证件类型
	 * @param idNo  证件号
	 * @return
	 */
	public static boolean addPerson(String groupId, 
									Memory memory, 
									String personName, 
									int sex, 
									boolean isBirthday, 
									String birthday,  
									int byIdType, 
									String idNo) {
		/*
		 *  入参
		 */
		NET_SDK_FACE_INFO_LIST_ITEM sFaceInfoItem = new NET_SDK_FACE_INFO_LIST_ITEM();

     // 性别,1-男,2-女,作为查询条件时,此参数填0,则表示此参数无效	
        sFaceInfoItem.sex = sex;	
     // 证件类型
        sFaceInfoItem.certificateType = byIdType;  
     // 生日设置
 		if(isBirthday) {
 			String[] birthdays = birthday.split("-");
 			
 			String formatBirthday = birthdays[0] + birthdays[1] + birthdays[2];
 			sFaceInfoItem.birthday = Integer.parseInt(formatBirthday);			
 		}
        try {
            System.arraycopy(personName.getBytes("UTF-8"), 0, sFaceInfoItem.name, 0, personName.getBytes("UTF-8").length);// 人员名字	
            //
            System.arraycopy(idNo.getBytes(), 0, sFaceInfoItem.certificateNum, 0, idNo.getBytes().length);// 证件号
            //System.arraycopy(mobile.getBytes(), 0, sFaceInfoItem.mobile, 0, mobile.getBytes().length);
            //System.arraycopy(number.getBytes(), 0, sFaceInfoItem.number, 0, number.getBytes().length);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        sFaceInfoItem.groups[0].groupId = Integer.parseInt(groupId);              
      //库id
        NET_SDK_FACE_INFO_GROUP_ITEM groupItem = LocalData.faceGroup.get(Integer.parseInt(groupId));
  		System.arraycopy(groupItem.guid, 0, sFaceInfoItem.groups[0].guid, 0, groupItem.guid.length); 	

		
		NET_SDK_FACE_INFO_ADD faceAdd = new NET_SDK_FACE_INFO_ADD();
		faceAdd.sFaceInfoItem = sFaceInfoItem;			
													  		
		// 图片张数、大小、缓存设置
		if(memory != null) {
			faceAdd.imgNum = 1;//图片张数
			faceAdd.haveImgData = 1;
			faceAdd.imgData = memory;
			//faceAdd.imgWidth = 440;
			//faceAdd.imgHeight = 620;
			faceAdd.imgLen = (int)memory.size();  // 图片大小			
		}
		
		Pointer pInputData = new Memory(faceAdd.size()); 
		CommonFunctions.SetStructDataToPointer(faceAdd, pInputData, 0);		
		IntByReference lpBytesReturned = new IntByReference();
		
				
		boolean bRet = LoginModule.netsdk.NET_SDK_FaceMatchOperate(LoginModule.m_hLoginHandle, ErrorCodeAndConst.NET_SDK_ADD_FACE_INFO, 
				pInputData, faceAdd.size(), null, 0, lpBytesReturned);	
		if (!bRet) {
            throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
        } else {
            System.out.println("增加目标成功");
        }
		//释放内存
		long peer = Pointer.nativeValue(pInputData);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(pInputData, 0);
		
		return bRet;
	}
	
	/**
	 * 修改人员信息
	 * @param groupId 人脸库ID
	 * @param uid  人员唯一标识符
	 * @param memory  图片数据
	 * @param personName  姓名
	 * @param sex  性别
	 * @param isBirthday  是否下发生日
	 * @param birthday  生日
	 * @param byIdType  证件类型
	 * @param idNo  证件号
	 * @return true：成功 ,  false：失败
	 */
	public static boolean modifyPerson(String groupId, 
									   String uid,
									   Memory memory, 
									   String personName, 
									   int sex, 
									   boolean isBirthday, 
									   String birthday,  
									   int byIdType, 
									   String idNo) {
		// 入参
		NET_SDK_FACE_INFO_GROUP_ITEM groupItem = LocalData.faceGroup.get(Integer.parseInt(groupId));
		NET_SDK_FACE_INFO_LIST_ITEM sFaceInfoItem = LocalData.faceList.get(Integer.parseInt(uid));
		 // 性别,1-男,2-女,作为查询条件时,此参数填0,则表示此参数无效	
        sFaceInfoItem.sex = sex;	
        // 证件类型
        sFaceInfoItem.certificateType = byIdType;  
        // 生日设置
 		if(isBirthday) {
 			String[] birthdays = birthday.split("-");
 			
 			String formatBirthday = birthdays[0] + birthdays[1] + birthdays[2];
 			sFaceInfoItem.birthday = Integer.parseInt(formatBirthday);			
 		}
        try {
            System.arraycopy(personName.getBytes("UTF-8"), 0, sFaceInfoItem.name, 0, personName.getBytes("UTF-8").length);// 人员名字	
            //
            System.arraycopy(idNo.getBytes(), 0, sFaceInfoItem.certificateNum, 0, idNo.getBytes().length);// 证件号
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        sFaceInfoItem.groups[0].groupId = Integer.parseInt(groupId);              
        //库id
  		System.arraycopy(groupItem.guid, 0, sFaceInfoItem.groups[0].guid, 0, groupItem.guid.length); 
		
		
		NET_SDK_FACE_INFO_ADD sFaceInfoAdd = new NET_SDK_FACE_INFO_ADD();
        sFaceInfoAdd.sFaceInfoItem = sFaceInfoItem;
        sFaceInfoAdd.imgData = memory;
        sFaceInfoAdd.imgLen = (int)memory.size();  // 图片大小	
        sFaceInfoAdd.haveImgData = 1;
        sFaceInfoAdd.imgNum = 1;
        //
        NET_SDK_FACE_INFO_EDIT sIn = new NET_SDK_FACE_INFO_EDIT();
        sIn.sFaceInfoItem = sFaceInfoAdd;
        sIn.delFaceImgs[0] = 1;
		
        Pointer pInputData = new Memory(sIn.size()); 
		CommonFunctions.SetStructDataToPointer(sIn, pInputData, 0);		
		IntByReference lpBytesReturned = new IntByReference();
		
				
		boolean bRet = LoginModule.netsdk.NET_SDK_FaceMatchOperate(LoginModule.m_hLoginHandle, ErrorCodeAndConst.NET_SDK_SET_FACE_INFO, 
				pInputData, sIn.size(), null, 0, lpBytesReturned);	
		if (!bRet) {
            throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
        } else {
            System.out.println("编辑目标成功");
        }
		//释放内存
		long peer = Pointer.nativeValue(pInputData);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(pInputData, 0);				  
		

		return true;
	}
	
	/**
	 * 删除人员信息
	 * @param groupId 人脸库ID
	 * @param sUID  人员唯一标识符
	 */
	public static boolean delPerson(String groupId, String sUID) {    
		/*
		 *  入参
		 */
		NET_SDK_FACE_INFO_GROUP_ITEM groupItem = LocalData.faceGroup.get(Integer.parseInt(groupId));
		NET_SDK_FACE_INFO_LIST_ITEM faceItem = LocalData.faceList.get(Integer.parseInt(sUID));
		
		NET_SDK_FACE_INFO_DEL sIn = new NET_SDK_FACE_INFO_DEL();
        sIn.groupsId[0] = groupItem.groupId;
        sIn.faceInfoListItemId = faceItem.itemId;
        Memory pInputData = new Memory(sIn.size());
		
        CommonFunctions.SetStructDataToPointer(sIn, pInputData, 0);		
		IntByReference lpBytesReturned = new IntByReference();
		
		boolean bRet = LoginModule.netsdk.NET_SDK_FaceMatchOperate(LoginModule.m_hLoginHandle, ErrorCodeAndConst.NET_SDK_DEL_FACE_INFO, 
				pInputData, sIn.size(), null, 0, lpBytesReturned);	
		if (!bRet) {
            throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
        } else {
            System.out.println("删除目标成功");
        }
		//释放内存
		long peer = Pointer.nativeValue(pInputData);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(pInputData, 0);
		
		return bRet;
	}
	
	/**
	 * 下载图片, 用于修改人员信息
	 * @param itemId 需要下载的目标id
	 * @param pszFileDst 存放文件路径
	 */
	public static boolean downloadPersonPic(int itemId, String pszFileDst) {
		/*
		 * 入参
		 */
		NET_SDK_FACE_INFO_IMG_GET sIn = new NET_SDK_FACE_INFO_IMG_GET();
		sIn.index = 1;
		sIn.itemId = itemId;
		
		Memory pInputData = new Memory(sIn.size());
		
        CommonFunctions.SetStructDataToPointer(sIn, pInputData, 0);		
		IntByReference lpBytesReturned = new IntByReference();
		
		Pointer pNativeData = new Memory(1024 * 1024); 
		
		boolean bRet = LoginModule.netsdk.NET_SDK_FaceMatchOperate(LoginModule.m_hLoginHandle, ErrorCodeAndConst.NET_SDK_GET_FACE_INFO_IMG, 
				pInputData, sIn.size(), pNativeData, 1024 * 1024, lpBytesReturned);	
		if (!bRet) {
            throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
        } else {
            System.out.println("获取目标图片成功");
            NET_SDK_FACE_INFO_IMG_DATA img = new NET_SDK_FACE_INFO_IMG_DATA();
            CommonFunctions.GetPointerDataToStruct(pNativeData, 0, img);
            img.read();
            
            byte[] data = img.imgData.getByteArray(0, img.imgLen);
            
			try {
				CommonFunctions.writeFileByBytes(pszFileDst,data,false);//数据写入文件中
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
            
        }
		//释放内存
		long peer = Pointer.nativeValue(pInputData);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(pInputData, 0);
		
		peer = Pointer.nativeValue(pNativeData);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(pNativeData, 0);
		
		return true;
	}


	
	//////////////////////////  查询事件对比记录   /////////////////////////
	private static LLong lFindHandle = new LLong(0);    // 查找句柄
	
	/**
	 * 获取查找句柄
	 * @param nChn  通道号
	 * @param startTime 开始时间
	 * @param endTime  结束时间
	 */
//	public static boolean findFile(int nChn, String startTime, String endTime) {
//		int type = NetSDKLib.EM_FILE_QUERY_TYPE.NET_FILE_QUERY_FACE;
//
//		/**
//		 *  查询条件
//		 */
//		MEDIAFILE_FACERECOGNITION_PARAM findContion = new MEDIAFILE_FACERECOGNITION_PARAM();
//		
//		// 开始时间
//		String[] starts = startTime.split(" ");
//		
//		findContion.stStartTime.dwYear = Integer.parseInt(starts[0].split("-")[0]);
//		findContion.stStartTime.dwMonth = Integer.parseInt(starts[0].split("-")[1]);
//		findContion.stStartTime.dwDay = Integer.parseInt(starts[0].split("-")[2]);
//		findContion.stStartTime.dwHour = Integer.parseInt(starts[1].split(":")[0]);
//		findContion.stStartTime.dwMinute = Integer.parseInt(starts[1].split(":")[1]);
//		findContion.stStartTime.dwSecond = Integer.parseInt(starts[1].split(":")[2]);
//
//		// 结束时间
//		String[] ends = endTime.split(" ");
//		findContion.stEndTime.dwYear = Integer.parseInt(ends[0].split("-")[0]);
//		findContion.stEndTime.dwMonth = Integer.parseInt(ends[0].split("-")[1]);
//		findContion.stEndTime.dwDay = Integer.parseInt(ends[0].split("-")[2]);
//		findContion.stEndTime.dwHour = Integer.parseInt(ends[1].split(":")[0]);
//		findContion.stEndTime.dwMinute = Integer.parseInt(ends[1].split(":")[1]);
//		findContion.stEndTime.dwSecond = Integer.parseInt(ends[1].split(":")[2]);
//		
//		// 通道号
//		findContion.nChannelId = nChn;
//		
//		/**
//		 * 以下注释的查询条件参数，目前设备不支持，后续会逐渐增加
//		 */
////		// 地点,支持模糊匹配 
////		String machineAddress = "";
////		System.arraycopy(machineAddress.getBytes(), 0, findContion.szMachineAddress, 0, machineAddress.getBytes().length);
////		
////		// 待查询报警类型
////		findContion.nAlarmType = EM_FACERECOGNITION_ALARM_TYPE.NET_FACERECOGNITION_ALARM_TYPE_ALL;
//		
////		// 人员组数 
////		findContion.nGroupIdNum = 1;  
////		
////		// 人员组ID(人脸库ID)
////		String groupId = "";
////		System.arraycopy(groupId.getBytes(), 0, findContion.szGroupIdArr[0].szGroupId, 0, groupId.getBytes().length);
////		
////		// 人员信息扩展是否有效
////		findContion.abPersonInfoEx = 1;     
////		
////		// 人员组ID(人脸库ID)
////		System.arraycopy(groupId.getBytes(), 0, findContion.stPersonInfoEx.szGroupID, 0, groupId.getBytes().length);
//		
//		findContion.write();
//		lFindHandle = LoginModule.netsdk.CLIENT_FindFileEx(LoginModule.m_hLoginHandle, type, findContion.getPointer(), null, 3000);
//		if(lFindHandle.longValue() == 0) {
//			System.err.println("FindFileEx Failed!" + ToolKits.getErrorCodePrint());
//			return false;
//		}
//		findContion.read();
//		
//		return true;
//	}
//	
	
	/**
	 * 查询对比数据
	 * @param nFindCount 每次查询的个数
	 */
//	public static MEDIAFILE_FACERECOGNITION_INFO[] findNextFile(int nFindCount) {
//		MEDIAFILE_FACERECOGNITION_INFO[] msg = new MEDIAFILE_FACERECOGNITION_INFO[nFindCount];
//		for (int i = 0; i < msg.length; ++i) {
//			msg[i] = new NetSDKLib.MEDIAFILE_FACERECOGNITION_INFO();
//			msg[i].bUseCandidatesEx = 1;
//		}
//		
//		int MemorySize = msg[0].size() * nFindCount;
//		Pointer pointer = new Memory(MemorySize);
//		pointer.clear(MemorySize);
//		
//		ToolKits.SetStructArrToPointerData(msg, pointer);
//
//		int nRetCount = LoginModule.netsdk.CLIENT_FindNextFileEx(lFindHandle, nFindCount, pointer, MemorySize, null, 3000);
//		ToolKits.GetPointerDataToStructArr(pointer, msg);
//		
//		if (nRetCount <= 0) {
//			System.err.println("FindNextFileEx failed!" + ToolKits.getErrorCodePrint());
//            return null;
//		} 
//
//		MEDIAFILE_FACERECOGNITION_INFO[] retInfo = new MEDIAFILE_FACERECOGNITION_INFO[nRetCount];
//		for (int i = 0; i < retInfo.length; ++i) {
//			retInfo[i] = new NetSDKLib.MEDIAFILE_FACERECOGNITION_INFO();
//			retInfo[i] = msg[i];
//		}
//		
//		return retInfo;	
//	}
//	
	public static void findCloseFile() {
		if(lFindHandle.longValue() != 0) {
			//LoginModule.netsdk.CLIENT_FindCloseEx(lFindHandle);	
			lFindHandle.setValue(0);
		}
	}
}
